/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.assets.characterviewer;

import com.badlogic.gdx.ApplicationAdapter;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.ai.msg.MessageDispatcher;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.GridPoint2;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.google.inject.Guice;
import com.google.inject.Injector;
import java.util.Random;
import technology.rocketjump.undermount.assets.GameMaterialDictionary;
import technology.rocketjump.undermount.assets.characterviewer.CharacterViewApplication;
import technology.rocketjump.undermount.assets.characterviewer.FurnitureViewerUI;
import technology.rocketjump.undermount.assets.entities.model.EntityAssetOrientation;
import technology.rocketjump.undermount.assets.model.GameMaterial;
import technology.rocketjump.undermount.assets.model.GameMaterialType;
import technology.rocketjump.undermount.entities.EntityAssetUpdater;
import technology.rocketjump.undermount.entities.behaviour.furniture.FurnitureBehaviour;
import technology.rocketjump.undermount.entities.components.DecorationInventoryComponent;
import technology.rocketjump.undermount.entities.components.FurnitureInventoryComponent;
import technology.rocketjump.undermount.entities.dictionaries.furniture.FurnitureTypeDictionary;
import technology.rocketjump.undermount.entities.factories.FurnitureEntityFactory;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.physical.furniture.FurnitureEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.furniture.FurnitureLayout;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantSpeciesDictionary;
import technology.rocketjump.undermount.guice.UndermountGuiceModule;
import technology.rocketjump.undermount.misc.VectorUtils;
import technology.rocketjump.undermount.rendering.DebugWindow;
import technology.rocketjump.undermount.rendering.RenderMode;
import technology.rocketjump.undermount.rendering.camera.PrimaryCameraWrapper;
import technology.rocketjump.undermount.rendering.entities.EntityRenderer;

public class FurnitureViewerApplication
extends ApplicationAdapter {
    private SpriteBatch batch;
    private ShapeRenderer shapeRenderer;
    private EntityRenderer entityRenderer;
    private FurnitureEntityFactory entityFactory;
    private PrimaryCameraWrapper cameraManager;
    private FurnitureTypeDictionary furnitureTypeDictionary;
    private GameMaterialDictionary gameMaterialDictionary;
    private PlantSpeciesDictionary plantSpeciesDictionary;
    private FurnitureViewerUI ui;
    private Entity currentEntity;
    private FurnitureEntityAttributes attributes;
    private GameMaterial backgroundMaterial;
    private GameMaterial mainMaterial;
    private GameMaterial highlightMaterial;
    private DebugWindow debugWindow;
    private GridPoint2 tilePostion;
    private EntityAssetUpdater assetUpdater;
    private MessageDispatcher messageDispatcher;
    private static final Color MAIN_TILE_COLOR = new Color(0.0f, 0.0f, 1.0f, 0.3f);
    private static final Color EXTRA_TILE_COLOR = new Color(0.0f, 1.0f, 1.0f, 0.3f);
    private static final Color WORKSPACE_TILE_COLOR = new Color(1.0f, 0.0f, 1.0f, 0.2f);
    private static final Color WORKSPACE_OFFSET_TILE_COLOR = new Color(1.0f, 0.0f, 0.0f, 0.2f);

    @Override
    public void create() {
        Injector injector = Guice.createInjector(new UndermountGuiceModule());
        this.entityRenderer = injector.getInstance(EntityRenderer.class);
        this.entityFactory = injector.getInstance(FurnitureEntityFactory.class);
        this.cameraManager = injector.getInstance(PrimaryCameraWrapper.class);
        this.debugWindow = injector.getInstance(DebugWindow.class);
        this.furnitureTypeDictionary = injector.getInstance(FurnitureTypeDictionary.class);
        this.gameMaterialDictionary = injector.getInstance(GameMaterialDictionary.class);
        this.plantSpeciesDictionary = injector.getInstance(PlantSpeciesDictionary.class);
        this.assetUpdater = injector.getInstance(EntityAssetUpdater.class);
        this.messageDispatcher = injector.getInstance(MessageDispatcher.class);
        this.debugWindow.offsetPosition.x = 250.0f;
        this.batch = new SpriteBatch();
        this.shapeRenderer = new ShapeRenderer();
        Random random = new Random();
        this.attributes = new FurnitureEntityAttributes(0L);
        this.attributes.setFurnitureType(this.furnitureTypeDictionary.getByName("BASIC_LANTERN"));
        this.attributes.getMaterials().put(GameMaterialType.WOOD, this.gameMaterialDictionary.getByName("Pine wood"));
        this.attributes.getMaterials().put(GameMaterialType.STONE, this.gameMaterialDictionary.getByName("Dolostone"));
        this.attributes.getMaterials().put(GameMaterialType.ORE, this.gameMaterialDictionary.getByName("Hematite"));
        this.attributes.getMaterials().put(GameMaterialType.GEM, this.gameMaterialDictionary.getByName("Ruby"));
        GameMaterial testMetal = new GameMaterial("Test metal material", -1L, GameMaterialType.METAL, "#DDDDDE", null, null, null, true);
        this.attributes.getMaterials().put(GameMaterialType.METAL, testMetal);
        this.attributes.setPrimaryMaterialType(GameMaterialType.METAL);
        Vector2 position = new Vector2(this.cameraManager.getCamera().viewportWidth * 0.6f, this.cameraManager.getCamera().viewportHeight * 0.9f);
        this.tilePostion = new GridPoint2((int)Math.floor(position.x), (int)Math.floor(position.y));
        this.currentEntity = this.entityFactory.create(this.attributes, this.tilePostion, new FurnitureBehaviour(), null);
        DecorationInventoryComponent decorationInventoryComponent = new DecorationInventoryComponent();
        decorationInventoryComponent.add(CharacterViewApplication.createItemEntity("Tool-Large-Hammer", injector));
        decorationInventoryComponent.add(CharacterViewApplication.createItemEntity("Tool-Axe", injector));
        this.currentEntity.addComponent(decorationInventoryComponent);
        FurnitureInventoryComponent furnitureInventoryComponent = new FurnitureInventoryComponent();
        try {
            furnitureInventoryComponent.add(CharacterViewApplication.createItemEntity("Resource-Ore-Unrefined", injector), this.messageDispatcher);
            furnitureInventoryComponent.add(CharacterViewApplication.createItemEntity("Resource-Stone-Unrefined", injector), this.messageDispatcher);
        }
        catch (FurnitureInventoryComponent.NotEnoughInventorySpaceException e) {
            e.printStackTrace();
        }
        this.currentEntity.addComponent(furnitureInventoryComponent);
        this.assetUpdater.updateEntityAssets(this.currentEntity);
        this.ui = injector.getInstance(FurnitureViewerUI.class);
        this.ui.init(this.currentEntity);
        Gdx.input.setInputProcessor(this.ui.getStage());
    }

    @Override
    public void render() {
        GridPoint2 offsetTile;
        this.renderBackground();
        this.shapeRenderer.setProjectionMatrix(this.cameraManager.getCamera().combined);
        this.shapeRenderer.setColor(EXTRA_TILE_COLOR);
        this.shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        Vector2 originalPosition = this.currentEntity.getLocationComponent().getWorldPosition().cpy();
        GridPoint2 tile = VectorUtils.toGridPoint(originalPosition);
        FurnitureLayout currentLayout = this.attributes.getCurrentLayout();
        for (GridPoint2 extraTileOffset : currentLayout.getExtraTiles()) {
            offsetTile = tile.cpy().add(extraTileOffset);
            this.shapeRenderer.rect(offsetTile.x, offsetTile.y, 1.0f, 1.0f);
        }
        this.shapeRenderer.setColor(MAIN_TILE_COLOR);
        this.shapeRenderer.rect(tile.x, tile.y, 1.0f, 1.0f);
        for (FurnitureLayout.Workspace workspace : currentLayout.getWorkspaces()) {
            this.shapeRenderer.setColor(WORKSPACE_TILE_COLOR);
            offsetTile = tile.cpy().add(workspace.getLocation());
            this.shapeRenderer.rect(offsetTile.x, offsetTile.y, 1.0f, 1.0f);
            this.shapeRenderer.setColor(WORKSPACE_OFFSET_TILE_COLOR);
            offsetTile = tile.cpy().add(workspace.getAccessedFrom());
            this.shapeRenderer.rect(offsetTile.x, offsetTile.y, 1.0f, 1.0f);
        }
        this.shapeRenderer.end();
        this.batch.begin();
        this.batch.setProjectionMatrix(this.cameraManager.getCamera().combined);
        this.renderEntityWithOrientation(originalPosition, EntityAssetOrientation.DOWN.toVector2(), 0.0f, 0.0f, RenderMode.DIFFUSE);
        this.renderEntityWithOrientation(originalPosition, EntityAssetOrientation.DOWN.toVector2(), -5.0f, 0.0f, RenderMode.NORMALS);
        this.batch.end();
        this.shapeRenderer.setColor(Color.BLUE);
        this.shapeRenderer.begin(ShapeRenderer.ShapeType.Line);
        this.shapeRenderer.line(originalPosition.x - 0.5f, originalPosition.y - 0.5f, originalPosition.x + 0.5f, originalPosition.y + 0.5f);
        this.shapeRenderer.line(originalPosition.x - 0.5f, originalPosition.y + 0.5f, originalPosition.x + 0.5f, originalPosition.y - 0.5f);
        this.shapeRenderer.end();
        this.ui.render();
        this.debugWindow.render();
    }

    private void renderEntityWithOrientation(Vector2 originalPosition, Vector2 orientation, float offsetX, float offsetY, RenderMode renderMode) {
        this.currentEntity.getLocationComponent().setWorldPosition(originalPosition.cpy().add(orientation), true);
        this.currentEntity.getLocationComponent().setWorldPosition(originalPosition.cpy().add(offsetX, offsetY), false);
        this.entityRenderer.render(this.currentEntity, (Batch)this.batch, renderMode, null, null);
        this.currentEntity.getLocationComponent().setWorldPosition(originalPosition, false);
    }

    private void renderBackground() {
        Gdx.gl.glClearColor(0.6f, 0.6f, 0.6f, 1.0f);
        Gdx.gl.glClear(16384);
        this.shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        this.shapeRenderer.setColor(0.7f, 0.7f, 0.7f, 1.0f);
        this.shapeRenderer.setProjectionMatrix(this.cameraManager.getCamera().combined);
        for (float x = 0.0f; x <= this.cameraManager.getCamera().viewportWidth + 1.0f; x += 0.5f) {
            for (float y = 0.0f; y <= this.cameraManager.getCamera().viewportHeight + 1.0f; y += 0.5f) {
                boolean yEven;
                boolean xEven = (float)Math.round(x) - x < 0.001f;
                boolean bl = yEven = (float)Math.round(y) - y < 0.001f;
                if ((!xEven || yEven) && (xEven || !yEven)) continue;
                this.shapeRenderer.rect(x, y, 0.5f, 0.5f);
            }
        }
        this.shapeRenderer.end();
    }

    @Override
    public void resize(int width, int height) {
        this.ui.onResize(width, height);
        this.cameraManager.onResize(width, height);
        this.cameraManager.getCamera().zoom = 0.8f;
        this.cameraManager.getCamera().update();
        this.debugWindow.onResize(width, height);
        Vector3 newPosition = new Vector3(width, height, 0.0f);
        newPosition.x *= 0.55f;
        newPosition.y *= 0.9f;
        this.cameraManager.getCamera().unproject(newPosition);
        newPosition.x = (float)Math.round(newPosition.x) + 0.5f;
        newPosition.y = (float)Math.round(newPosition.y) + 0.5f;
        this.currentEntity.getLocationComponent().setWorldPosition(new Vector2(newPosition.x, newPosition.y), false);
    }

    @Override
    public void dispose() {
        this.ui.dispose();
        this.batch.dispose();
    }
}

